/*
 * Decompiled with CFR 0.152.
 */
package net.ftb.util;

import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.CodeSource;
import java.util.Enumeration;
import java.util.Map;
import net.ftb.gui.LaunchFrame;
import net.ftb.log.Logger;
import net.ftb.util.FileUtils;
import net.ftb.util.winreg.JavaFinder;

public class OSUtils {
    private static byte[] cachedMacAddress;
    private static String cachedUserHome;
    private static int numCores;

    public static String getDefInstallPath() {
        try {
            CodeSource codeSource = LaunchFrame.class.getProtectionDomain().getCodeSource();
            File jarFile = new File(codeSource.getLocation().toURI().getPath());
            return jarFile.getParentFile().getPath();
        }
        catch (URISyntaxException e) {
            Logger.logError("Unexcepted error", e);
            Logger.logWarn("Failed to get path for current directory - falling back to user's home directory.");
            return System.getProperty("user.dir") + "//FTB Pack Install";
        }
    }

    public static String getDynamicStorageLocation() {
        switch (OSUtils.getCurrentOS()) {
            case WINDOWS: {
                return System.getenv("APPDATA") + "/ftblauncher/";
            }
            case MACOSX: {
                return cachedUserHome + "/Library/Application Support/ftblauncher/";
            }
            case UNIX: {
                return cachedUserHome + "/.ftblauncher/";
            }
        }
        return OSUtils.getDefInstallPath() + "/temp/";
    }

    public static String getCacheStorageLocation() {
        switch (OSUtils.getCurrentOS()) {
            case WINDOWS: {
                if (System.getenv("LOCALAPPDATA") != null && System.getenv("LOCALAPPDATA").length() > 5) {
                    return System.getenv("LOCALAPPDATA") + "/ftblauncher/";
                }
                return System.getenv("APPDATA") + "/ftblauncher/";
            }
            case MACOSX: {
                return cachedUserHome + "/Library/Application Support/ftblauncher/";
            }
            case UNIX: {
                return cachedUserHome + "/.ftblauncher/";
            }
        }
        return OSUtils.getDefInstallPath() + "/temp/";
    }

    public static void createStorageLocations() {
        File cacheDir = new File(OSUtils.getCacheStorageLocation());
        File dynamicDir = new File(OSUtils.getDynamicStorageLocation());
        if (!cacheDir.exists()) {
            cacheDir.mkdirs();
            if (dynamicDir.exists() && !cacheDir.equals(dynamicDir)) {
                Logger.logInfo("Migrating cached Maps from Roaming to Local storage");
                FileUtils.move(new File(dynamicDir, "Maps"), new File(cacheDir, "Maps"));
                Logger.logInfo("Migrating cached Modpacks from Roaming to Local storage");
                FileUtils.move(new File(dynamicDir, "ModPacks"), new File(cacheDir, "ModPacks"));
                Logger.logInfo("Migrating cached Texturepacks from Roaming to Local storage");
                FileUtils.move(new File(dynamicDir, "TexturePacks"), new File(cacheDir, "TexturePacks"));
                Logger.logInfo("Migration complete.");
            }
        }
        if (!dynamicDir.exists()) {
            dynamicDir.mkdirs();
        }
        if (OSUtils.getCurrentOS() == OS.WINDOWS) {
            File oldLoginData = new File(dynamicDir, "logindata");
            File newLoginData = new File(cacheDir, "logindata");
            try {
                if (oldLoginData.exists() && !oldLoginData.getCanonicalPath().equals(newLoginData.getCanonicalPath())) {
                    newLoginData.delete();
                }
            }
            catch (Exception e) {
                Logger.logError("Error deleting login data", e);
            }
        }
    }

    public static long getOSTotalMemory() {
        return OSUtils.getOSMemory("getTotalPhysicalMemorySize", "Could not get RAM Value");
    }

    public static long getOSFreeMemory() {
        return OSUtils.getOSMemory("getFreePhysicalMemorySize", "Could not get free RAM Value");
    }

    private static long getOSMemory(String methodName, String warning) {
        long ram = 0L;
        OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        try {
            Method m = operatingSystemMXBean.getClass().getDeclaredMethod(methodName, new Class[0]);
            m.setAccessible(true);
            Object value = m.invoke((Object)operatingSystemMXBean, new Object[0]);
            if (value != null) {
                ram = Long.valueOf(value.toString()) / 1024L / 1024L;
            } else {
                Logger.logWarn(warning);
                ram = 1024L;
            }
        }
        catch (Exception e) {
            Logger.logError("Error while getting OS memory info", e);
        }
        return ram;
    }

    public static String getJavaDelimiter() {
        switch (OSUtils.getCurrentOS()) {
            case WINDOWS: {
                return ";";
            }
            case UNIX: {
                return ":";
            }
            case MACOSX: {
                return ":";
            }
        }
        return ";";
    }

    public static OS getCurrentOS() {
        String osString = System.getProperty("os.name").toLowerCase();
        if (osString.contains("win")) {
            return OS.WINDOWS;
        }
        if (osString.contains("nix") || osString.contains("nux")) {
            return OS.UNIX;
        }
        if (osString.contains("mac")) {
            return OS.MACOSX;
        }
        return OS.OTHER;
    }

    public static boolean is64BitWindows() {
        String arch = System.getenv("PROCESSOR_ARCHITECTURE");
        String wow64Arch = System.getenv("PROCESSOR_ARCHITEW6432");
        return arch.endsWith("64") || wow64Arch != null && wow64Arch.endsWith("64");
    }

    public static boolean is64BitPosix() {
        String result = "";
        try {
            String line;
            Process command = Runtime.getRuntime().exec("uname -m");
            BufferedReader in = new BufferedReader(new InputStreamReader(command.getInputStream()));
            while ((line = in.readLine()) != null) {
                result = result + line + "\n";
            }
        }
        catch (Exception e) {
            Logger.logError("Posix bitness check failed", e);
        }
        return result.contains("_64");
    }

    public static boolean is64BitOSX() {
        String result = "";
        if (!System.getProperty("os.version").startsWith("10.6") && !System.getProperty("os.version").startsWith("10.5")) {
            return true;
        }
        try {
            String line;
            Process command = Runtime.getRuntime().exec("/usr/sbin/sysctl -n hw.cpu64bit_capable");
            BufferedReader in = new BufferedReader(new InputStreamReader(command.getInputStream()));
            while ((line = in.readLine()) != null) {
                result = result + line + "\n";
            }
        }
        catch (Exception e) {
            Logger.logError("OS X bitness check failed", e);
        }
        return result.equals("1");
    }

    public static boolean is64BitOS() {
        switch (OSUtils.getCurrentOS()) {
            case WINDOWS: {
                return OSUtils.is64BitWindows();
            }
            case UNIX: {
                return OSUtils.is64BitPosix();
            }
            case MACOSX: {
                return OSUtils.is64BitOSX();
            }
            case OTHER: {
                return true;
            }
        }
        return true;
    }

    public static Boolean is64BitVM() {
        Boolean bits64 = (OSUtils.getCurrentOS() == OS.WINDOWS || OSUtils.getCurrentOS() == OS.MACOSX) && JavaFinder.parseJavaVersion() != null ? Boolean.valueOf(JavaFinder.parseJavaVersion().is64bits) : Boolean.valueOf(System.getProperty("sun.arch.data.model").equals("64"));
        return bits64;
    }

    public static String getOSString() {
        String osString = System.getProperty("os.name").toLowerCase();
        if (osString.contains("win")) {
            return "Windows";
        }
        if (osString.contains("linux")) {
            return "linux";
        }
        if (osString.contains("mac")) {
            return "OSX";
        }
        return osString;
    }

    public static boolean verifyUUID() {
        return true;
    }

    public static byte[] getMacAddress() {
        if (cachedMacAddress != null && cachedMacAddress.length >= 10) {
            return cachedMacAddress;
        }
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface network = networkInterfaces.nextElement();
                byte[] mac = network.getHardwareAddress();
                if (mac == null || mac.length <= 0 || network.isLoopback() || network.isVirtual() || network.isPointToPoint()) continue;
                Logger.logDebug("Interface: " + network.getDisplayName() + " : " + network.getName());
                cachedMacAddress = new byte[mac.length * 10];
                for (int i = 0; i < cachedMacAddress.length; ++i) {
                    OSUtils.cachedMacAddress[i] = mac[i - Math.round(i / mac.length) * mac.length];
                }
                return cachedMacAddress;
            }
        }
        catch (SocketException e) {
            Logger.logWarn("Exception getting MAC address", e);
        }
        Logger.logWarn("Failed to get MAC address, using default logindata key");
        return new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    }

    public static void browse(String url) {
        try {
            if (Desktop.isDesktopSupported()) {
                Desktop.getDesktop().browse(new URI(url));
            } else if (OSUtils.getCurrentOS() == OS.UNIX && (new File("/usr/bin/xdg-open").exists() || new File("/usr/local/bin/xdg-open").exists())) {
                new ProcessBuilder("xdg-open", url).start();
            } else {
                Logger.logWarn("Could not open Java Download url, not supported");
            }
        }
        catch (Exception e) {
            Logger.logError("Could not open link", e);
        }
    }

    public static void open(File path) {
        if (!path.exists()) {
            return;
        }
        try {
            if (Desktop.isDesktopSupported()) {
                Desktop.getDesktop().open(path);
            } else if (OSUtils.getCurrentOS() == OS.UNIX && (new File("/usr/bin/xdg-open").exists() || new File("/usr/local/bin/xdg-open").exists())) {
                new ProcessBuilder("xdg-open", path.toString()).start();
            }
        }
        catch (Exception e) {
            Logger.logError("Could not open file", e);
        }
    }

    public static boolean canRun7OnMac() {
        return OSUtils.getCurrentOS() == OS.MACOSX && !System.getProperty("os.version").startsWith("10.6") && !System.getProperty("os.version").startsWith("10.5");
    }

    public static void cleanEnvVars(Map<String, String> environment) {
        environment.remove("_JAVA_OPTIONS");
        environment.remove("JAVA_TOOL_OPTIONS");
        environment.remove("JAVA_OPTIONS");
    }

    public static int getNumCores() {
        return numCores;
    }

    static {
        cachedUserHome = System.getProperty("user.home");
        numCores = Runtime.getRuntime().availableProcessors();
    }

    public static enum OS {
        WINDOWS,
        UNIX,
        MACOSX,
        OTHER;

    }
}

